<?php 
   /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "../classi/Contenuto.php";
    include "../template/stile.php";
    
    include "include/controlloLogin.php";
    $configurazioneAspetto = recuperaConfigurazioneColori($geecomDb);
    
    if(isset($_GET["id"])) {
        $contenuto = new Contenuto($geecomDb,filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $contenuto->caricaDatiDalDatabase();
    }
    else {
        $contenuto = new Contenuto($geecomDb,0);
    }
    
    $status = (isset($_GET["status"])) ? filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT) : 0;            
    
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "include/cssBaseAreaAmministrativa.php";
        ?>
        <title>Geecom Admin - Creazione contenuto</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "include/barraSuperiore.php";

                include "include/header.php";

                include "include/barraMenu.php";
            ?>
        </header>

    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            
            <form action="../controller/controllerContenuti.php" method="post">
                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Pagina modificata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        else if($status==210) {
                             echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Pagina duplicata, modificala per non avere due contenuti uguali
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        else if($status==320) {
                             echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Traduzione creata, inserisci i testi nella lingua da te scelta
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        else if($status==350) {
                             echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Impostazioni sezione componente aggiornate
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                    ?>
                    <input type="text" class="d-none" name="operazione" value="<?= ($contenuto->getId()>0) ? "modifica" : "creaPagina" ?>">
                    <input type="text" class="d-none" name="id" value="<?= ($contenuto->getId()>0) ? $contenuto->getId() : "0" ?>">
                    <input type="text" class="d-none" name="lingua" value="<?= ($contenuto->getId()>0) ? $contenuto->getLingua() : $impostazioni["linguaSito"] ?>">
                    <input type="text" class="d-none" name="autore" value="<?= ($contenuto->getId()>0) ? $contenuto->getAutore() : $_SESSION["geecomAdmin_nomeCognome"] ?>">
                    <input type="text" class="d-none" name="tipo" value="pagina">
                    
                    <div class="col-lg-8 ">
                        <div class="form-row justify-content-between mb-3">
                            <div class="col-auto d-flex">
                                <nav aria-label="breadcrumb" class="align-self-center">
                                    <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                        <li class="breadcrumb-item"><a href="home.php">Home</a></li>
                                        <li class="breadcrumb-item"><a href="gestionePagine.php">Pagine</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($contenuto)? $contenuto->getTitolo() : "Nuova pagina"))?></li>
                                    </ol>
                                </nav>
                            </div>
                            
                            <div class="col-auto text-right">
                                <a class="btn btn-primary mr-1" href="creaContenuto.php">Crea nuova<i class="fas fa-plus ml-2"></i></a>
                                <a class="btn btn-outline-primary" href="gestionePagine.php<?php echo(isset($contenuto) ? "?lingua={$contenuto->getLingua()}" : "") ?>"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                            </div>
                        </div>
                        <div class="card mb-4 box-shadow-lite">
                            <div class="card-header py-3">
                                <div class="row">
                                    <div class="form-group col-lg-8">
                                        <label for="titolo-articolo">Titolo</label>
                                        <input  type="text" class="form-control" id="titolo-articolo" name="titolo" value="<?php echo((isset($contenuto)? $contenuto->getTitolo() : ""))?>" placeholder="Titolo della pagina">
                                    </div>
                                    <div class="form-group col-lg-4">
                                        <label for="mostraTitolo" class="d-block">Mostra titolo</label>
                                        <input type="checkbox" id="mostraTitolo" name="mostraTitolo" class="js-switch" value="si" <?php echo((isset($contenuto) && $contenuto->getMostraTitolo()=="si") ? "checked" :"") ?> >
                                    </div>
                                </div>
                                
                                <div class="row">
		                    <?php 
		                        if($contenuto->getId()!=0 && $contenuto->getTitolo()!="" && $contenuto->getAlias()!="") {
		                    ?>
		                            <div class="form-group col-md-5">
		                                <label for="url-seo">Alias</label>
		                                <input type="text" class="form-control" id="url-seo" name="alias" value="<?php echo(($contenuto->getId()!=0? $contenuto->getAlias() : ""))?>" placeholder="Alias">
		                                <small class="text-muted">Campo associato al contenuto composto dai caratteri del titolo senza spazi. Viene compilato in automatico da Geecom, ma hai la possibilità di variarlo </small>
		                            </div>
		                            
		                            <div class="form-group col-md-7">
		                                <label for="url-seo">URL</label>
		                                <input type="text" class="form-control" id="url-seo" name="alias" value="<?php echo(($contenuto->getId()!=0? GeneratoreUrl::creaUrlContenuto($contenuto->getDatiContenuto(), $impostazioni["ottimizzazioneUrl"], $impostazioni["urlPiattaforma"]) : ""))?>" disabled>
		                                <small class="text-muted"> l'URL a cui è raggiungibile il contenuto </small>
		                            </div>
		                    <?php
		                        }
		                    ?>
		                        <div class="form-group col-md-5">
		                            <label for="sottotitolo-articolo">Meta titolo</label>
		                            <textarea class="form-control" id="metaTitolo" name="metaTitolo" rows="2"><?php echo(($contenuto->getId()!=0? $contenuto->getMetaTitolo() : ""))?></textarea>
		                            <small class="text-muted">Viene inserito nel tag title della pagina. Può essere diverso dal titolo</small>
		                        </div>

		                        <div class="form-group col-md-7">
		                            <label for="sottotitolo-articolo">Meta descrizione</label>
		                            <textarea class="form-control" id="descrizione" name="metaDescrizione" rows="2"><?php echo(($contenuto->getId()!=0? $contenuto->getMetaDescrizione() : ""))?></textarea>
		                            <small class="text-muted"> Inserisci una breve descrizione di questo contenuto, verrà mostrata nei risultati di ricerca di Google </small>
		                        </div>
                                </div>
                                
                                <div class="row">
                                    <div class="form-group col-lg-4">
                                        <label for="stato" class="d-block">Pubblicato</label>
                                        <input type="checkbox" id="stato" name="stato" class="js-switch" value="pubblicato" <?php echo((isset($contenuto) && $contenuto->getStato()=="pubblicato") ? "checked" :"") ?> >
                                    </div>
                                    
                                    <div class="form-group col-lg-4">
                                        <label for="descrizione" class="d-block">Pagina privata</label>
                                        <input type="checkbox" id="privato" name="privato" class="js-switch" value="si" <?php echo((isset($contenuto) && $contenuto->getPrivato()=="si") ? "checked" :"") ?> >
                                        <small class="d-block text-muted">Sarà visibile solo dagli utenti registrati</small>
                                    </div>
                                </div>
                             </div>
                            
                            <div class="card mx-4 mt-4 rounded-0 accordion">
                                <div class="card-header collapsed" data-toggle="collapse" href="#css-aggiuntivo">
                                    <a class="card-title">CSS aggiuntivo</a>
                                </div>
                                <div id="css-aggiuntivo" class="collapse">
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="css-aggiuntivo-area">CSS generato per questa pagina</label>
                                            <textarea disabled class="form-control" id="css-aggiuntivo-area" rows="3"><?php echo((isset($contenuto)? $contenuto->getCssGenerato() : ""))?></textarea>
                                            <small>Il CSS presente in questa textarea viene generato da Geecom a partire dalla definizione delle opzioni delle sezioni presenti in questa pagina</small>
                                        </div>
                                    </div>
                                </div>
                                
                                <div id="css-aggiuntivo" class="collapse">
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="css-aggiuntivo-area">CSS specifico per questa pagina</label>
                                            <textarea name="cssAggiuntivo" class="form-control" id="css-aggiuntivo-area" rows="3"><?php echo((isset($contenuto)? $contenuto->getCssAggiuntivo() : ""))?></textarea>
                                            <small>Definisci le classi CSS personalizzate valide solo per questa pagina</small>
                                        </div>
                                    </div>
                                </div>                         
                            </div>
                            
                            <div class="card-body wrapper-sezioni-pagina">
                                <div id="componentiContenuto">
                                    <?php 
                                        if(isset($contenuto)) {
                                            $contenuto->stampaComponentiContenuto();
                                        }
                                    ?>
                                </div>
                                <button type="button" class="btn btn-success btn-block" data-toggle="modal" data-target="#aggiungi-componente"><i class="fas fa-plus"></i> Aggiungi un componente</button>
                                <button type="submit" class="btn btn-primary float-right mt-3"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                    </div><!--/Colonna principale -->
                    <!-- Colonna principale -->
                    
                    <!--Colonna secondaria -->
                    <div class="col-lg-4  align-self-start sticky-top">
                        <div class="btn-group d-flex mb-3" role="group" aria-label="Basic example">
                            <button type="submit" class="btn btn-primary w-100"><i class="fas fa-check mr-2"></i>Salva</button>
                            <?php 
                                if(isset($contenuto)) {
                            ?>
                                    <button type="button" class="btn btn-warning w-100" onclick="location.href='../controller/controllerContenuti.php?id=<?php echo $contenuto->getId() ?>&operazione=duplica';"><i class="far fa-clone mr-2"></i>Duplica</button>
                                    <button type="button" class="btn btn-secondary w-100" onclick="window.open('<?php echo GeneratoreUrl::creaUrlContenuto($contenuto->getDatiContenuto(), $impostazioni["ottimizzazioneUrl"], $impostazioni["urlPiattaforma"]) ?>','_blank');"><i class="fas fa-external-link-square-alt mr-2"></i>Visualizza</button>
                            <?php
                                }
                            
                            ?>
                        </div>
                        <div class="clearfix"></div>
                        <?php
                            if(isset($contenuto)) {
                                $analisiSeo               = $contenuto->eseguiAnalisiSeo();
                                $caratteriTitolo          = strlen($contenuto->getTitolo());
                                $caratteriMetaDescrizione = strlen($contenuto->getMetaDescrizione());
                                $caratteriTesto           = $contenuto->contaTestoContenuto();
                        ?>
                            <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                <div class="card-header collapsed" data-toggle="collapse" href="#SEO">
                                    <a class="card-title">
                                        SEO <?php echo $analisiSeo["esito"] ?>
                                    </a>
                                </div>
                                <div id="SEO" class="collapse p-0">
                                    <div class="card-body p-0">
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item <?php echo(($caratteriTitolo<20) ? "text-danger" : "text-success") ?>"><strong>Titolo:</strong> <?php echo $caratteriTitolo ?> caratteri </li>
                                            <li class="list-group-item <?php echo(($caratteriMetaDescrizione<50) ? "text-danger" : "text-success") ?>"><strong>Meta descrizione:</strong> <?php echo $caratteriMetaDescrizione ?> caratteri </li>
                                            <li class="list-group-item <?php echo(($caratteriTesto<500) ? "text-danger" : "text-success") ?>"><strong>Testo:</strong> <?php echo $caratteriTesto ?> caratteri </li>
                                            <?php 
                                                if(count($analisiSeo["suggerimenti"])==0) {
                                                    echo"<li class=\"list-group-item text-success\"> <i class=\"far fa-thumbs-up\"></i> Nessun suggerimento, bravo! </li>";
                                                }
                                                else {
                                                    foreach($analisiSeo["suggerimenti"] as $suggerimento) {
                                                        echo"<li class=\"list-group-item\">$suggerimento </li>";
                                                    }
                                                }
                                            ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        <?php
                            }
                        ?>
                        
                        <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                <div class="card-header collapsed" data-toggle="collapse" href="#divAutore">
                                    <a class="card-title">
                                        Autore
                                    </a>
                                </div>
                                <div id="divAutore" class="collapse show">
                                    <div class="card-body">
                                        <div class="form-group mb-0">
                                            <select class="form-control" name="autore">
                                                <?php
                                                    $query = "SELECT * FROM geec_utenti WHERE ruolo LIKE 'super admin' OR ruolo LIKE 'amministratore'";
                                                    $risAmministratori = $geecomDb->eseguiQueryLettura($query);
                                                    while($amministratore = $risAmministratori->fetch_assoc()) {
                                                        if(isset($contenuto) && $contenuto->getAutore()==$amministratore["nome"]." ".$amministratore["cognome"]) {
                                                            echo"<option value=\"{$amministratore["nome"]} {$amministratore["cognome"]}\" selected>{$amministratore["nome"]} {$amministratore["cognome"]} </option>";						
                                                        }
                                                        else if(!isset($contenuto) && $amministratore["nome"]." ".$amministratore["cognome"] && $_SESSION["geecomAdmin_nomeCognome"]) {
                                                            echo"<option value=\"{$amministratore["nome"]} {$amministratore["cognome"]}\" selected>{$amministratore["nome"]} {$amministratore["cognome"]} </option>";
                                                        }
                                                        else {
                                                            echo"<option value=\"{$amministratore["nome"]} {$amministratore["cognome"]}\" >{$amministratore["nome"]} {$amministratore["cognome"]} </option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        
                            <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                <div class="card-header collapsed" data-toggle="collapse" href="#template">
                                    <a class="card-title">
                                        Template contenuto
                                    </a>
                                </div>
                                <div id="template" class="collapse show">
                                    <div class="card-body">
                                        <div class="form-group mb-0">
                                            <select class="form-control" name="template">
                                                <?php
                                                    foreach($templatePagine as $key=>$value) {
                                                        if(isset($contenuto) && $contenuto->getTemplate()==$value) {
                                                            echo"<option value=\"$value\" selected>$key </option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"$value\" >$key </option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
            
                        <?php 
                            if(isset($contenuto)) {
                        ?>
                        <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                            <div class="card-header collapsed" data-toggle="collapse" href="#ImmagineInEvidenza">
                                <a class="card-title">
                                    Immagine in evidenza
                                </a>
                            </div>
                            <div id="ImmagineInEvidenza" class="collapse show">
                                <div class="card-body">
                                    <div class="img-container">
                                        <div class="azioni">
                                            <div class="btn-group" role="group" aria-label="">
                                                <button onclick="eliminaImmagineInEvidenza()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                            </div>
                                        </div>
                                        <img id="immagineInEvidenza" class="img-fluid w-100 mb-3" src="../<?php echo((isset($contenuto) && $contenuto->getFoto()!="") ? $contenuto->getFoto() : "immagini/altro/segnaposto.png") ?>" alt="immagine attuale">
                                    </div>

                                    <form action="../controller/controllerContenuti.php" id="frmFileUpload-00" class="dropzone singolo-file" method="post" enctype="multipart/form-data">
                                        <div class="dz-message">
                                            <i class="fas fa-file-upload fa-2x mb-2"></i>
                                            <h5>Trascina o carica qui l'immagine</h5>
                                        </div>
                                        <div class="fallback">
                                            <input name="file" type="file" />
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
            
                        <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                            <div class="card-header collapsed" data-toggle="collapse" href="#traduzioni" aria-expanded="false">
                                <a class="card-title">
                                    Traduzioni
                                </a>
                            </div>
                            <div id="traduzioni" class="card-body collapse show" style="">
                                <div class="d-flex justify-content-between  align-items-center">
                                    <span>Questa pagina è in <strong><?= strtoupper($contenuto->getLingua()) ?></strong> </span>
                                    <img src="../<?= percorsoImmagineBandiera($contenuto->getLingua()) ?>" alt="<?= $contenuto->getLingua() ?>">
                                </div>
                                <?php
                                    if($contenuto->getContenutoRiferimento()==0) {
                                        $queryTraduzioni = "SELECT * FROM geecAd_contenuti WHERE contenutoRiferimento={$contenuto->getId()} AND tipo LIKE '{$contenuto->getTipo()}'";
                                    }
                                    else {
                                        $queryTraduzioni = "SELECT * FROM geecAd_contenuti WHERE id={$contenuto->getContenutoRiferimento()} OR (contenutoRiferimento={$contenuto->getContenutoRiferimento()} AND tipo LIKE '{$contenuto->getTipo()}' AND id!={$contenuto->getId()})";
                                    }
                                    
                                    $result = $geecomDb->eseguiQueryLettura($queryTraduzioni);
                                    if($result->num_rows>0) {
                                        echo"<hr>
                                        <p>Traduzioni associate:</p>";                                            
                                    }

                                    while($traduzione=$result->fetch_assoc()) {
                                        unset($lingue[array_search($traduzione["linguaContenuto"], $lingue)]);
                                ?>
                                        <div class="d-flex justify-content-between align-items-center mb-2" id="pagina<?php echo $traduzione["id"] ?>">
                                            <div>
                                                <button type="button" onclick="eliminaPagina(<?php echo $traduzione["id"] ?>,'<?php echo $traduzione["titolo"] ?>')" class="btn btn-light btn-sm mr-1 text-secondary" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Elimina"><i class="far fa-trash-alt"></i></button>
                                                <a href="creaContenuto.php?id=<?php echo $traduzione["id"] ?>"><?php echo $traduzione["titolo"] ?></a>
                                            </div>
                                            <img src="../<?php echo percorsoImmagineBandiera($traduzione["linguaContenuto"]) ?>" alt="<?php echo $traduzione["linguaContenuto"] ?>">
                                        </div>
                                <?php
                                    }
                                ?>
                                <hr>
                                <div class="input-group">
                                    <select class="form-control" id="linguaTraduzione">
                                        <option selected="">Crea una traduzione...</option>
                                        <?php
                                            // elimina la lingua del contenuto
                                            unset($lingue[array_search($contenuto->getLingua(), $lingue)]);
                                            foreach($lingue as $lingua) {
                                                echo"<option value=\"$lingua\" >$lingua </option>";
                                            }
                                        ?>
                                    </select>
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="button" onclick="traduci(<?php echo(($contenuto->getContenutoRiferimento()==0) ? $contenuto->getId() : $contenuto->getContenutoRiferimento()) ?>)">Crea</button>
                                    </div>
                                </div>
                            </div>
                    </div>
                        <?php
                            }
                        ?>
                    </div><!--/Colonna secondaria -->
                </form>

            </div>
        </div>
    </main>

    <?php 
        include "include/footer.php";
        
        include "include/modal/cambiaPassword.php";
                
        include "include/modal/modalMenuComponenti.php";
        
        include "include/modal/operazioneCompletata.php";
        
        if(isset($contenuto)) {
            include "include/modalAggiungiComponente.php";
            include "include/modalAggiungiComponenteSezione.php";
        }
    ?>
	  
        
	<!-- MODALS  -->
	<div class="modal fade" id="modifica-impostazioni-sezione" tabindex="-1" role="dialog" aria-labelledby="modifica impostazioni sezione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Opzioni sezione</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form name="formImpostazioniSezione" action="../controller/controllerContenuti.php" method="post" enctype="multipart/form-data">
                            <input type="text" class="d-none" name="id" value="<?php echo((isset($contenuto)) ? $contenuto->getId() : "0") ?>">
                            <input type="text" class="d-none" id="idSezioneDaModificare" name="idSezioneDaModificare">
                            <input type="text" class="d-none" name="operazione" value="modificaOpzioniSezione">
                            <div class="form-group row">
                                  <label for="idSezione" class="col-sm-2 col-form-label">ID</label>
                                  <div class="col-sm-10">
                                    <input type="text" class="form-control" id="idSezione" name="idSezione" placeholder="ID">
                                    <small class="form-text text-muted"> L'ID deve essere unico </small>
                                  </div>
                            </div>
                            <div class="form-group row">
                                  <label for="classeSezione" class="col-sm-2 col-form-label">Classi</label>
                                  <div class="col-sm-10">
                                    <input type="text" class="form-control" id="classeSezione" name="classeSezione" placeholder="classi">
                                    <small class="form-text text-muted"> Inserisci le classi aggiuntive separate da uno spazio, ad es.: "mt-0 bg-dark text-negative"</small>
                                  </div>
                            </div>
                            <hr>
                            <div class="form-group" id="contenitoreCheckboxLarghezza">
                                <input type="checkbox" id="sezioneATuttaLarghezza" name="sezioneATuttaLarghezza" value="si" />
                                <label>A tutta larghezza</label>
                            </div>
                            <hr>
                            <div class="form-row">
                                <div class="form-group col-sm-6">
                                    <label>Margine</label>
                                    <input type="text" class="form-control" id="margineSezione" name="margineSezione" value="">
                                    <small class="form-text text-muted"> Personalizza il margine della sezione, ad es.: "1em 1em 1em 1em"</small>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label>Padding</label>
                                    <input type="text" class="form-control" id="paddingSezione" name="paddingSezione" placeholder="">
                                    <small class="form-text text-muted"> Personalizza il padding della sezione, ad es.: "1em 1em 1em 1em"</small>
                                </div>
                            </div>

                            <hr class="mt-0">
                            <h6> Colore di sfondo </h6>
                            <div class="form-row">
                                <div class="form-group col-sm-6">
                                    <div id="divContenitoreColorPicker" class="">
                                        
                                    </div>
                                    <small class="form-text text-muted">Se non impostato la sezione avrà uno sfondo trasparente</small>
                                </div>
                                <div class="form-group col-sm-6">
                                    <select class="form-control" id="colore-predefinito-valore" onchange="aggiornaColoreSezione()">
                                        <option value="">Seleziona tra i colori predefiniti</option>
                                        <option value="<?php echo $configurazioneAspetto["colorePrimario"] ?>">Primary</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreSecondario"] ?>">Secondary</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreSuccess"] ?>">Success</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreDanger"] ?>">Danger</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreWarning"] ?>">Warning</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreInfo"] ?>">Info</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreDark"] ?>">Dark</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreLight"] ?>">Light</option>
                                    </select>
                                </div>
                            </div>
                            
                            <hr class="mt-0">
                            <div class="form-row">
                                <div class="form-group col-sm-9">
                                    <h6> Immagine di sfondo </h6>
                                    <input name="file" type="file" accept="image/*"/>
                                    <small class="d-block text-muted form-text">Se presente, l'immagine di sfondo verrà visualizzata al posto del video sui dispositivi che non ne consentono la riproduzione.</small>
                                </div>
                                <div class="form-group col-sm-3">
                                    <div class="img-container">
                                        <div class="azioni">
                                            <div class="btn-group" role="group" aria-label="">
                                                <button onclick="eliminaImmagineSezione()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                            </div>
                                        </div>
                                        <img id="immagineDiSfondoSezione" class="img-fluid"  alt="immagine sezione">
                                    </div>
                                </div>
                            </div>
                            
                            <hr class="mt-0">
                            <div class="form-row">
                                <div class="form-group col-sm-9">
                                    <h6> Video di sfondo </h6>
                                    <input name="video" type="file" accept="video/*" />
                                </div>
                                <div class="form-group col-sm-3">
                                    <div class="video-container">
                                        <div class="azioni">
                                            <div class="btn-group" role="group" aria-label="">
                                                <button onclick="eliminaVideoSezione()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                            </div>
                                        </div>
                                        <video id="videoDiSfondoSezione" class="embed-responsive embed-responsive-16by9" poster="../immagini/altro/segnaposto.png" >
                                            <source id="sorgenteVideoDiSfondo" src="" type="video/mp4">
                                        </video>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="modal-footer">
                          <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                          <button type="button" class="btn btn-primary btn-sm" onclick="document.formImpostazioniSezione.submit()"><i class="fas fa-check"></i> Salva</button>
                    </div>
                  </div>
            </div>
        </div>
	
        <div class="modal fade" id="modalEliminaTraduzione" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Eliminare la pagina?</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <div class="align-self-center text-center">
                                <span class="align-self-center text-primary"><em id="nomePaginaDaEliminare"></em></span>
                                <div id="tipoElementoDaEliminare"></div>
                            </div>
                        </div>
                        <input type="text" class="d-none" id="paginaDaEliminare">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazionePagina()"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="modal fade" id="modalEliminaComponente" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Eliminare il componente?</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <img id="immagineComponenteDaEliminare" class="thumb d-none d-lg-block" src="">
                            <div class="align-self-center">
                                <span class="mr-3 align-self-center text-primary"><em id="nomeComponenteDaEliminare"></em></span>
                                <div id="nomeElementoDaEliminare"></div>
                            </div>
                        </div>
                        <input type="text" class="d-none" id="componenteDaEliminare">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneComponentePagina()"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="modal fade" id="modalEliminaComponenteSezioneMultipla" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Eliminare il componente?</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <img id="immagineComponenteSezioneDaEliminare" class="thumb d-none d-lg-block" src="">
                            <div class="align-self-center">
                                <span class="mr-3 align-self-center text-primary"><em id="nomeComponenteSezioneDaEliminare"></em></span>
                                <div id="nomeElementoSezioneDaEliminare"></div>
                            </div>
                        </div>
                        <input type="text" class="d-none" id="componenteSezioneDaEliminare">
                        <input type="text" class="d-none" id="idSezioneComponenteDaEliminare">
                        <input type="text" class="d-none" id="idPosizioneComponenteDaEliminare">
                        <input type="text" class="d-none" id="tabellaSezioneComponenteDaEliminare">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneComponenteSezione()"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
        
        <?php
            include "include/modalModificheComponenti.php";
            
            include "include/jsBaseAreaAmministrativa.php";
        ?>
        <!-- Dropzone -->
        <script type="text/javascript" src="../plugins/dropzone/dropzone.js"></script>
        <script>
            $("#frmFileUpload-00").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.webp,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineInEvidenza").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaImmagine",
                    id:<?php echo $contenuto->getId() ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
        </script>

        <script>
            function modificaImpostazioniSezione(id,idSezione,classeSezione,aTuttaLarghezza,margineSezione,paddindSezione,coloreSfondo,immagineDiSfondo,videoDiSfondo) {
                document.getElementById("idSezioneDaModificare").value = id;
                document.getElementById("idSezione").value      = idSezione;
                document.getElementById("classeSezione").value  = classeSezione;
                document.getElementById("margineSezione").value = margineSezione;
                document.getElementById("paddingSezione").value = paddindSezione;
                
                if (typeof switchModalSezione !== 'undefined') {
                    switchModalSezione.destroy();
                    document.getElementById("contenitoreCheckboxLarghezza").innerHTML = "";
                    
                    document.getElementById("contenitoreCheckboxLarghezza").innerHTML = "<input type=\"checkbox\" id=\"sezioneATuttaLarghezza\" name=\"sezioneATuttaLarghezza\" value=\"si\" /><label>A tutta larghezza</label>";                    
                }
                
                var checkboxSezioneATuttaLarghezza = document.getElementById("sezioneATuttaLarghezza");
                if(aTuttaLarghezza==='si') {    
                    checkboxSezioneATuttaLarghezza.checked   = true;
                }
                checkboxSezioneATuttaLarghezza.className = "js-switch-modal";
                
                var elementoSwitchModal = document.querySelector('.js-switch-modal');
                switchModalSezione  = new Switchery(elementoSwitchModal,{ size: 'small', color: 'var(--primary)', jackColor: '#FFF' });
                
                // creo il colorpicker
                if (typeof colorPickerSezione !== 'undefined') {
                    $('.selettore-colore').colorpicker('destroy');
                    
                    document.getElementById("divContenitoreColorPicker").innerHTML = "<input type=\"text\" id=\"coloreSfondo\" name=\"coloreSfondo\" class=\"form-control\" /><span class=\"input-group-append\"><span class=\"input-group-addon input-group-text\"><i></i></span></span>";
                    document.getElementById("divContenitoreColorPicker").className = "input-group colorpicker-component selettore-colore";
                    document.getElementById("coloreSfondo").value   = coloreSfondo;

                    colorPickerSezione = $('.selettore-colore').colorpicker({
                        format: 'hex'
                    });
                }
                else {
                
                    document.getElementById("divContenitoreColorPicker").innerHTML = "<input type=\"text\" id=\"coloreSfondo\" name=\"coloreSfondo\" class=\"form-control\" /><span class=\"input-group-append\"><span class=\"input-group-addon input-group-text\"><i></i></span></span>";
                    document.getElementById("divContenitoreColorPicker").className = "input-group colorpicker-component selettore-colore";
                    document.getElementById("coloreSfondo").value   = coloreSfondo;

                    colorPickerSezione = $('.selettore-colore').colorpicker({
                        format: 'hex'
                    });
                }
                
                if(immagineDiSfondo=="") {
                    document.getElementById("immagineDiSfondoSezione").src = "../immagini/altro/segnaposto.png";
                }
                else {
                    document.getElementById("immagineDiSfondoSezione").src = "../"+immagineDiSfondo;
                }
                
                var video = document.getElementById("videoDiSfondoSezione");
                if(videoDiSfondo=="") {
                    video.setAttribute('poster','../immagini/altro/segnaposto.png');
                    if (video.hasAttribute("controls")) {
                        video.removeAttribute("controls")   
                    }
                }
                else {
                    video.removeAttribute('poster');
                    if (!video.hasAttribute("controls")) {
                        video.setAttribute("controls","controls")   
                    }
                    document.getElementById("sorgenteVideoDiSfondo").src = "../"+videoDiSfondo;
                    video.load();
                }
                
                $('#modifica-impostazioni-sezione').modal('show');
            }
            
            function modificaPosizioneComponenteDaInput(idComponente) {
                var posizione = document.getElementById("posizioneComponente"+idComponente).value;
                modificaPosizioneComponente(idComponente,posizione);
            }
            
            function modificaPosizioneComponente(idComponente,posizione) {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"modificaPosizioneComponente",
                        id:<?php echo $contenuto->getId() ?>,
                        idComponente:idComponente,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {                
                            aggiornaComponentiPagina();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
    
            function duplicaComponente(idComponente) {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"duplicaComponente",
                        id:<?php echo $contenuto->getId() ?>,
                        idComponente:idComponente
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaComponentiPagina();
                        }
                        else if(esito=="ok,ricarica") {
                            aggiornaComponentiPagina();
                            location.reload();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function aggiornaComponentiPagina() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"stampaComponentiContenuto",
                        id:<?php echo $contenuto->getId() ?>
                    },
                    success:function(codice) {
                        document.getElementById("componentiContenuto").innerHTML = codice;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function eliminaComponentePagina(id,immagineComponente,nomeComponente,nomeElemento) {
                $('#componenteDaEliminare').val(id);
                document.getElementById("immagineComponenteDaEliminare").src = immagineComponente;
                $('#nomeComponenteDaEliminare').text(nomeComponente);
                document.getElementById("nomeElementoDaEliminare").innerHTML = nomeElemento;
                $('#modalEliminaComponente').modal('show');
            }
            
            function eseguiEliminazioneComponentePagina() {
                var id = $('#componenteDaEliminare').val();
                $.ajax({
                    type:"GET",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"eliminaComponente",
                        id:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("componentePagina"+id).className = "d-none";
                            $('#modalEliminaComponente').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function cambiaIdElemento(idComponente) {
                var idElemento = $("#idElementoComponente"+idComponente).val();
                
                $.ajax({
                    type:"GET",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"cambiaIdElemento",
                        id:idComponente,
                        idElemento:idElemento
                    },
                    success:function(result) {
                        if(result=="ok") {
                            $('#labelOperazioneCompletata').text("Componente aggiornato con successo");
                            $('#modalOperazioneCompletata').modal('show');
                            aggiornaComponentiPagina();
                        }
                        else {
                            alert(result);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function eliminaImmagineInEvidenza() {
                $.ajax({
                    type:"GET",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"eliminaImmagineInEvidenza",
                        id:<?php echo $contenuto->getId() ?>
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("immagineInEvidenza").src="../immagini/altro/segnaposto.png";
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function traduci(id) {
                var l =$('#linguaTraduzione').val();
                location.href="../controller/controllerContenuti.php?id="+id+"&operazione=traduci&lingua="+l;
            }
            
            function eliminaPagina(id,titoloPagina) {
                $('#paginaDaEliminare').val(id);
                $('#nomePaginaDaEliminare').text(titoloPagina);
                $('#modalEliminaTraduzione').modal('show');
            }

            function eseguiEliminazionePagina() {
                var id = $('#paginaDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"elimina",
                        id:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("pagina"+id).className = "d-none";
                            $('#modalEliminaTraduzione').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function eliminaImmagineSezione() {
                var idSezione = document.getElementById("idSezioneDaModificare").value;
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"eliminaImmagineSezione",
                        id:<?php echo $contenuto->getId() ?>,
                        idSezione:idSezione
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("immagineDiSfondoSezione").src="../immagini/altro/segnaposto.png";
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaColoreSezione() {
                var coloreSfondo = document.getElementById("colore-predefinito-valore").value;
                
                if(coloreSfondo!="") {
                    document.getElementById("coloreSfondo").value   = coloreSfondo;
                    $('.selettore-colore').colorpicker('setValue', coloreSfondo);
                }
            }
            
            function eliminaImmagineSezione() {
                var idSezione = document.getElementById("idSezioneDaModificare").value;
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"eliminaImmagineSezione",
                        id:<?php echo $contenuto->getId() ?>,
                        idSezione:idSezione
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("immagineDiSfondoSezione").src="../immagini/altro/segnaposto.png";
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function eliminaVideoSezione() {
                var idSezione = document.getElementById("idSezioneDaModificare").value;
                
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"eliminaVideoSezione",
                        id:<?php echo $contenuto->getId() ?>,
                        idSezione:idSezione
                    },
                    success:function(result) {
                        if(result=="ok") {
                            var video = document.getElementById("videoDiSfondoSezione");
                            video.pause();
                            video.removeAttribute('controls');
                            video.setAttribute('poster','../immagini/altro/segnaposto.png');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function apriPopupAggiungiComponenteSezione(idSezione,posizioneComponente,tabellaSezione) {
                $('#idSezioneNuovoElemento').val(idSezione);
                $('#posizioneNuovoElementoSezione').val(posizioneComponente);
                $('#tabellaSezioneNuovoElemento').val(tabellaSezione);
                
                $('#aggiungi-componente-sezione').modal('show');
            }
            
            function eseguiAggiuntaComponenteSezione(idComponente) {
                var idPaginaSezione               = $('#idPaginaSezione').val();
                var idSezioneNuovoElemento        = $('#idSezioneNuovoElemento').val();
                var posizioneNuovoElementoSezione = $('#posizioneNuovoElementoSezione').val();
                var tabellaSezioneNuovoElemento   = $('#tabellaSezioneNuovoElemento').val();
                
                location.href = "../controller/controllerContenuti.php?operazione=aggiungiComponenteSezione&idPagina="+idPaginaSezione+"&tabellaSezione="+tabellaSezioneNuovoElemento+"&idSezioneNuovoElemento="+idSezioneNuovoElemento+"&posizioneNuovoElementoSezione="+posizioneNuovoElementoSezione+"&idComponente="+idComponente;
            }
                                    
            function aggiornaDivSezioneMultipla(id) {
                var proporzioniSezione = $('#proporzioniSezione'+id).val();
                var arrayClassi        = proporzioniSezione.split(",");
                
                document.getElementById('div1SezioneMultipla'+id).className = arrayClassi[0]+" d-flex align-items-stretch";
                document.getElementById('div2SezioneMultipla'+id).className = arrayClassi[1]+" d-flex align-items-stretch";
                if(arrayClassi.length==3) {
                    document.getElementById('div3SezioneMultipla'+id).className = arrayClassi[2]+" d-flex align-items-stretch";
                }
            }
            
            function salvaDatiSezioneMultipla(id,tabella) {
                
                if(tabella!="geec_sezioniAQuattroColonne") {
                    var proporzioni  = document.getElementById('proporzioniSezione'+id).value;
                }
                else {
                    var proporzioni  = "";
                }
                var allineamento = document.getElementById('allineamentoSezione'+id).value;
                
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"cambiaDatiSezioneMultipla",
                        tabella:tabella,
                        idSezione:id,
                        proporzioni:proporzioni,
                        allineamento:allineamento
                    },
                    success:function(result) {
                        if(result=="ok") {
                            $('#labelOperazioneCompletata').text("Dati sezione aggiornati");
                            $('#modalOperazioneCompletata').modal('show');
                        }
                        else {
                            alert(result)
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function eliminaComponenteSezione(id,idSezione,posizioneComponente,immagineComponente,nomeComponente,nomeElemento,tabellaSezione) {
                $('#componenteSezioneDaEliminare').val(id);
                $('#idSezioneComponenteDaEliminare').val(idSezione);
                $('#idPosizioneComponenteDaEliminare').val(posizioneComponente);
                $('#tabellaSezioneComponenteDaEliminare').val(tabellaSezione);
                document.getElementById("immagineComponenteSezioneDaEliminare").src = immagineComponente;
                $('#nomeComponenteSezioneDaEliminare').text(nomeComponente);
                document.getElementById("nomeElementoSezioneDaEliminare").innerHTML = nomeElemento;
                $('#modalEliminaComponenteSezioneMultipla').modal('show');
            }
            
            function eseguiEliminazioneComponenteSezione() {
                var id        = $('#componenteSezioneDaEliminare').val();
                var idSezione = $('#idSezioneComponenteDaEliminare').val();
                var tabellaSezione    = $('#tabellaSezioneComponenteDaEliminare').val();
                var posizioneElemento = $('#idPosizioneComponenteDaEliminare').val();
                
                $.ajax({
                    type:"GET",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"eliminaComponenteSezione",
                        id:id,
                        idSezione:idSezione,
                        tabellaSezione:tabellaSezione,
                        posizioneElemento:posizioneElemento
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            location.reload();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
  </body>
</html>
